/**
 * Klasse GridCell
 * 
 * 	Eigene Klasse zur Verwaltung der einzelnen Zellenellen innerhalb des Gitternetzes (Grid).
 *	Eine jede Zelle enthlt die genaue Position der Zelle im Raster, 
 *	sowie Verweise auf aktive Boids und Hindernisse, sowie deren Anzahl.
 *
 * Attribute
 * 
 * itemCount {int} Anzahl Boid Objekte in dieser Zelle
 * items {Boid[]} Verweise auf die Boid Objekte in dieser Zelle
 * gridLocation {int[3]} Position der Zelle im Gitternetz
 * obstacleCount {int} Anzahl Hindernisse, die die Zelle mglicherweise schneiden
 * obstacles {Obstacle[]} Verweise auf Hindernisse, die die Zelle mglicherweise schneiden
 *
 *
 */




/**
 * GridCell(x, y, z) : GridCell
 * 	Kostruktor und zugleich Definition der Klasse GridCell
 * 
 * Parameter
 * 
 * 	x {float} x - Komponente der Position der Zelle im Gitternetz
 * 	y {float} y - Komponente der Position der Zelle im Gitternetz
 * 	z {float} z - Komponente der Position der Zelle im Gitternetz
 * 
 * Rckgabewert
 * 
 * 	{GridCell} neues GridCell Objekt
 * 
 */
function GridCell(x ,y ,z){
	this.itemCount = 0; 
	this.items = []; 
	this.gridLocation = [x, y, z]; 
	this.obstacleCount = 0;
	this.obstacles = [];
	
}

/**
 * Methode addItem(item) : void
 * 	
 * 	Fgt der aktuellen Zelle eine Referenz auf ein Boid Objekt hinzu, dabei wird auch
 * 	gleich this.itemCount inkrementiert. 
 * 
 * Parameter
 * 
 * 	item {Boid} Das Boid Objekt das der Zelle hinzugefgt werden soll
 * 
 * Klassenmethode zu GridCell
 * 
 */
GridCell.prototype.addItem = function(item){
	this.items[this.itemCount] = item;
	this.itemCount++;
};

/**
 * Methode addObstacle(obstacle) : void
 * 
 * 	Fgt der aktuellen Zelle eine Referenz auf ein Hindernis (Obstacle Objekt) hinzu, dabei wird auch
 * 	gleich this.obstacleCount inkrementiert. 
 * 
 * Parameter
 * 	
 * 	obstacle {Obstacle} Das Hindernis das in der Zelle vermerkt werden soll
 * 
 * Klassenmethode zu GridCell
 */
GridCell.prototype.addObstacle = function(obstacle){
	//sicherheitsabfrage, ob obstacle bereits vermerkt
	var obstaclePresent = false;
	for(var i = 0, max = this.obstacleCount;i<max;i++){
		if(this.obstacles.name == obstacle.name){
			obstaclePresent = true;
		}
	}
	if (!obstaclePresent){
		this.obstacles[this.obstacleCount] = obstacle;
		this.obstacleCount++;
	}
};

/**
 * Methode getGridLocation() : int[3]
 * 	
 * 	prinzipiell unntiger "getter" zur Rckgabe der position im Gitternetz
 * 
 * Rckgabewert
 * 
 * {int[3]} Position der aktuellen Zelle im Gitternetz
 * 
 */
GridCell.prototype.getGridLocation = function(){
	return this.gridLocation;
};